function [idx,dir2,ord] = synsubidx(varargin)
%This function works in conjunction with synsubset to generate and index
%that is verified to be the desired distance and whether it is pre or post
%synaptic
%Synatax:   [idx,dir2,dir3] = synsubidx('dist',4,'prepost',1,'dir1','c:\...','file1','syn.csv','dir2',..,'dir3',..)
%Input:     'dist' = the distance by which this new subclass is determined,
%               specifically, it is the distance of the selected channel
%               from the origin that is specified here.  Default = 1.
%           'dir1' = the directory the the selected channel, e.g., the
%                channel that is used to define the new subclass
%           'file1' = the file that contains the vertices of the channel
%               that is generated by savpivots that will be used to define
%               the new subclass.
%           'dir2' = the directory where the origin dataset from savpivots
%               resides, in most instances, will be same as dir1.
%           'file2' = the origin vertices
%           'dir3' = the directory where the termini dataset resides
%           'file3' = the termini vertices
%           'prepost' = actually really origin or termi, 0 = origin, and 1
%               = termi, default = 0.
%           'propstr' = the tag on the properties file.  Default = 'prop'
%           note: if nothing is entered, you will be prompted to select
%           dir1, dir2, dir3.
%Output:    idx = the indexed used to specifiy the new subset
%           dir2 = the directory where the original class files are
%           ord = the ordinals of the selected vertices

[dist,dir2,vert,idxprop,ori_vert,termi_vert,prepost,ord] = parse(varargin);

%now generate the index
if prepost==0   %near origin
    d1 = dddist(vert,ori_vert);     %distance of vert to origin
    d2 = dddist(vert,termi_vert);   %distance of vert to termini
    idx_tmp = d1<d2;   %closer to origin
    idx_tmp2 = idxprop(:,end)<=dist;    %vertices that meets distance criterial
    %combine the two and go
    idx = and(idx_tmp,idx_tmp2);    %both correspond = gold.
else    %near termini
    d1 = dddist(vert,ori_vert);     %distance of vert to origin
    d2 = dddist(vert,termi_vert);   %distance of vert to termini
    idx_tmp = d2<d1;   %closer to termini
    idx_tmp2 = idxprop(:,end)<=dist;    %vertices that meets distance criterial
    %combine the two and go
    idx = and(idx_tmp,idx_tmp2);    %both correspond = gold.
end
ord = ord(idx,:);   %the selected ordinals

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dist,dir2,vert,idxprop,ori_vert,termi_vert,prepost,ord] = parse(input)

dist = 1;
dir1 = [];
dir2 = [];      %we will assume dir2 is the same as dir3, most likely true. 
dir3 = [];
file1 = [];
file2 = [];
file3 = [];
prepost = 0;
propstr = 'prop';   %default prop

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dist'
                    dist = input{1,i+1};
                case 'dir1'
                    dir1 = input{1,i+1};
                case 'dir2'
                    dir2 = input{1,i+1};
                case 'dir3'
                    dir3 = input{1,i+1};
                case 'file1'
                    file1 = input{1,i+1};
                case 'file2'
                    file2 = input{1,i+1};
                case 'file3'
                    file3 = input{1,i+1};
                case 'prepost'
                    prepost = input{1,i+1};
                case 'propstr'
                    propstr = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if isempty(dir1)||isempty(file1)    %no directory or vertices file entered
    [file1,dir1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the vertices file','Multiselect','off');
end

vert = single(dlmread([dir1,file1],',',1,0));    %open the file
vert = vert(:,1:3);     %three amigos
%now open the properties files for these vertices, this is all in the
%environment setup by the savpivots
dir_info = dir(dir1);   %grab the file info from dir2

try
    %pull out the channel name
    stridx = file1=='_';
    stridx = find(stridx==1);   %the second '_' is the one
    propfile = pullfile(dir_info,file1(stridx(1)+1:stridx(2)-1),propstr);   %pull the file
catch   %strange and long filenames with lots of punctuations
    %pull out the channel name
    stridx = isstrprop(file1,'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    try
    propfile = pullfile2(dir_info,file1(stridx(1)+1:stridx(end-1)-1),propstr);
    catch
        keyboard
    end
end
%open the prop file
idxprop = single(dlmread([dir1,propfile],',',1,0));

%now check if dir2 and 3 are entered
if isempty(dir2)||isempty(file2)   %vert mode will generate it's own dir2
    [file2,dir2,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the origin vertices file','Multiselect','off');
end
ori_vert = single(dlmread([dir2,file2],',',1,0));    %open the file
ord = ori_vert(:,end);  %grab the ordinals
ori_vert = ori_vert(:,1:3);     %just the first three

if isempty(dir3)||isempty(file3)
    [file3,dir3,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open the termini vertices file','Multiselect','off');
end
termi_vert = single(dlmread([dir3,file3],',',1,0));    %open the file
termi_vert = termi_vert(:,1:3);     %dri

%--------------------------------------------------------------------------
%subfunction pull properties file
function [filename] = pullfile(dir_struct,matchstr,propstr)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
list = names(~idx);

for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    stridx = isstrprop(list{j},'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    if strcmp(propstr,list{j}(1:stridx(1)-1)) %first step
        if strcmp(list{j}(stridx(1)+1:stridx(2)-1),matchstr)    %the match we are looking for
            filename = list{j};
        end
    end
end
%--------------------------------------------------------------------------
%subfunction pull properties file for long file names with lots of
%punctuations
function [filename] = pullfile2(dir_struct,matchstr,propstr)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
list = names(~idx);

for j = 1:size(list,2);
    %the only files we care about are the flat rotated vertices and the properties for now
    stridx = isstrprop(list{j},'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    if strcmp(propstr,list{j}(1:stridx(1)-1)) %first step
        if strcmp(list{j}(stridx(1)+1:stridx(end)-1),matchstr)    %the match we are looking for
            filename = list{j};
        end
    end
end